/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.upload;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.model.dto.ApiResponse;
import eu.openanalytics.crane.upload.UploadAuditing;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.BlockingInputStreamAsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.Upload;

@Controller
public class UploadController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private S3TransferManager transferManager;
    private final CraneConfig config;
    private final UploadAuditing auditingService;

    public UploadController(CraneConfig config, UploadAuditing auditingService) {
        this.config = config;
        this.auditingService = auditingService;
    }

    @PostConstruct
    private void init() {
        if (this.config.usesS3()) {
            S3AsyncClient s3AsyncClient = (S3AsyncClient)S3AsyncClient.builder().multipartEnabled(Boolean.valueOf(true)).build();
            this.transferManager = S3TransferManager.builder().s3Client(s3AsyncClient).build();
        }
    }

    @PreAuthorize(value="@uploadAccessControlService.canAccess(#r, #p)")
    @ResponseBody
    @PostMapping(value={"/__file/{repository}/{*path}"}, produces={"application/json"})
    public ResponseEntity<ApiResponse<Map<String, Object>>> createResource(HttpServletRequest request, @P(value="r") @PathVariable(name="repository") String stringRepository, @P(value="p") @PathVariable(name="path") String stringPath) {
        boolean isMultipartForm = JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipartForm) {
            this.auditingService.createErrorHandlerAuditEvent(request, HttpStatus.BAD_REQUEST);
            return ApiResponse.fail(Map.of("message", "Request wasn't a multipart form"));
        }
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        Repository repository = this.config.getRepository(stringRepository);
        Path path = repository.getStoragePath().resolve(stringPath.substring(1));
        if (Files.exists(path, new LinkOption[0])) {
            this.auditingService.createErrorHandlerAuditEvent(request, HttpStatus.BAD_REQUEST);
            return ApiResponse.fail(Map.of("message", "File %s already exists".formatted(stringRepository + stringPath)));
        }
        try {
            FileItemInput fileItemInput = this.getFileItemInput(upload.getItemIterator(request));
            if (fileItemInput == null) {
                this.auditingService.createErrorHandlerAuditEvent(request, HttpStatus.BAD_REQUEST);
                return ApiResponse.fail(Map.of("message", "Upload failed. No parameter named `file` found"));
            }
            if (path.toString().startsWith("s3://")) {
                this.writeFileToS3(fileItemInput, path);
            } else if (path.toString().startsWith("/")) {
                FileUtils.copyInputStreamToFile((InputStream)fileItemInput.getInputStream(), (File)path.toFile());
                if (repository.hasPosixAccessControl()) {
                    Map<String, Object> pathAttributes = Files.readAttributes(path.getParent(), "unix:owner,uid,gid,permissions", new LinkOption[0]);
                    for (String attr : pathAttributes.keySet()) {
                        try {
                            Files.setAttribute(path, "unix:" + attr, pathAttributes.get(attr), new LinkOption[0]);
                        }
                        catch (IOException e) {
                            this.logger.warn("Crane could not set '{}' unix attribute of '{}'", (Object)attr, (Object)path);
                        }
                    }
                }
            } else {
                throw new RuntimeException("Path type no supported %s!".formatted(path.toString()));
            }
            this.auditingService.createUploadAuditEvent(request);
            return ApiResponse.success(Map.of("message", "File upload succeeded"));
        }
        catch (IOException e) {
            this.auditingService.createErrorHandlerAuditEvent(request, HttpStatus.BAD_REQUEST);
            return ApiResponse.fail(Map.of("message", "File upload failed"));
        }
    }

    @Nullable
    private FileItemInput getFileItemInput(FileItemInputIterator itemInputIterator) throws IOException {
        while (itemInputIterator.hasNext()) {
            FileItemInput temporaryFileItemInput = itemInputIterator.next();
            if (!temporaryFileItemInput.getFieldName().equals("file")) continue;
            return temporaryFileItemInput;
        }
        return null;
    }

    private void writeFileToS3(FileItemInput fileItemInput, Path path) throws IOException {
        BlockingInputStreamAsyncRequestBody body = AsyncRequestBody.forBlockingInputStream(null);
        S3Path s3Path = (S3Path)path;
        Upload s3UploadRequest = this.transferManager.upload(builder -> builder.requestBody((AsyncRequestBody)body).putObjectRequest(req -> req.bucket(s3Path.getBucketName()).key(s3Path.getKey())).build());
        body.writeInputStream(fileItemInput.getInputStream());
        s3UploadRequest.completionFuture().join();
    }
}

