/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service.spel;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import eu.openanalytics.crane.service.spel.SpecExpressionContext;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.stereotype.Component;

@Component
public class SpecExpressionResolver {
    private final ApplicationContext appContext;
    private final ExpressionParser expressionParser;
    private final Cache<SpecExpressionContext, StandardEvaluationContext> evaluationCache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final ParserContext beanExpressionParserContext = new /* Unavailable Anonymous Inner Class!! */;

    public SpecExpressionResolver(ApplicationContext appContext) {
        this.appContext = appContext;
        this.expressionParser = new SpelExpressionParser();
    }

    public Object evaluate(String expression, SpecExpressionContext context) {
        if (expression == null) {
            return null;
        }
        if (expression.isEmpty()) {
            return "";
        }
        Expression expr = this.expressionParser.parseExpression(expression, this.beanExpressionParserContext);
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.appContext).getBeanFactory();
        StandardEvaluationContext sec = (StandardEvaluationContext)this.evaluationCache.get((Object)context, arg_0 -> this.lambda$evaluate$0(context, (ConfigurableBeanFactory)beanFactory, arg_0));
        return expr.getValue((EvaluationContext)sec);
    }

    public String evaluateToString(String expression, SpecExpressionContext context) {
        return String.valueOf(this.evaluate(expression, context));
    }

    public Boolean evaluateToBoolean(String expression, SpecExpressionContext context) {
        return Boolean.valueOf(this.evaluateToString(expression, context));
    }

    private /* synthetic */ StandardEvaluationContext lambda$evaluate$0(SpecExpressionContext context, ConfigurableBeanFactory beanFactory, SpecExpressionContext k) {
        StandardEvaluationContext result = new StandardEvaluationContext();
        result.setRootObject((Object)context);
        result.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
        result.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        result.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        result.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        result.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.appContext));
        result.setTypeLocator((TypeLocator)new StandardTypeLocator(beanFactory.getBeanClassLoader()));
        ConversionService conversionService = beanFactory.getConversionService();
        if (conversionService != null) {
            result.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        return result;
    }
}

