/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service.spel;

import eu.openanalytics.crane.model.config.Repository;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpecExpressionContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Path path;
    private Repository repository;
    private List<String> groups;
    private Map<String, Object> claims;
    private final List<Matcher> parsed = new ArrayList();

    public static SpecExpressionContext create(Object ... objects) {
        SpecExpressionContext ctx = new SpecExpressionContext();
        for (Object o : objects) {
            if (o instanceof Repository) {
                ctx.repository = (Repository)o;
            } else if (o instanceof DefaultOidcUser) {
                ctx.claims = ((DefaultOidcUser)o).getClaims();
            } else if (o instanceof JwtAuthenticationToken) {
                ctx.claims = ((Jwt)((JwtAuthenticationToken)o).getToken()).getClaims();
            }
            if (o instanceof Authentication) {
                ctx.groups = SpecExpressionContext.getGroups((Authentication)((Authentication)o));
            }
            if (o instanceof HttpServletRequest) {
                ctx.request = (HttpServletRequest)o;
            }
            if (o instanceof HttpServletResponse) {
                ctx.response = (HttpServletResponse)o;
            }
            if (!(o instanceof Path)) continue;
            ctx.path = (Path)o;
        }
        return ctx;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public List<Matcher> getParsed() {
        return this.parsed;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean parse(String pattern, String input) {
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(input);
        this.parsed.add(matcher);
        return matcher.matches();
    }

    public List<String> toList(String attribute, String regex) {
        if (attribute == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(attribute.split(regex)).map(String::trim).collect(Collectors.toList());
    }

    public List<String> toList(String attribute) {
        return this.toList(attribute, ",");
    }

    public List<String> toLowerCaseList(String attribute, String regex) {
        if (attribute == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(attribute.split(regex)).map(it -> it.trim().toLowerCase()).collect(Collectors.toList());
    }

    public List<String> toLowerCaseList(String attribute) {
        return this.toLowerCaseList(attribute, ",");
    }

    public boolean isOneOf(String attribute, String ... allowedValues) {
        if (attribute == null) {
            return false;
        }
        return Arrays.stream(allowedValues).anyMatch(it -> it.trim().equals(attribute.trim()));
    }

    public boolean isOneOfIgnoreCase(String attribute, String ... allowedValues) {
        if (attribute == null) {
            return false;
        }
        return Arrays.stream(allowedValues).anyMatch(it -> it.trim().equalsIgnoreCase(attribute.trim()));
    }

    public <T> T eval(T result, Object ... objects) {
        return result;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    private static List<String> getGroups(Authentication auth) {
        ArrayList<String> groups = new ArrayList<String>();
        if (auth != null) {
            for (GrantedAuthority grantedAuth : auth.getAuthorities()) {
                String authName = grantedAuth.getAuthority().toUpperCase();
                if (authName.startsWith("ROLE_")) {
                    authName = authName.substring(5);
                }
                groups.add(authName);
            }
        }
        return groups;
    }
}

