/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.security.CraneUser;
import eu.openanalytics.crane.service.UserService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class AbstractPosixAccessControlService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UserService userService;
    protected final CraneConfig craneConfig;

    protected AbstractPosixAccessControlService(UserService userService, CraneConfig craneConfig) {
        this.userService = userService;
        this.craneConfig = craneConfig;
    }

    protected abstract PosixFilePermission getOwnerAccess();

    protected abstract PosixFilePermission getGroupAccess();

    public boolean canAccess(Repository repository, String stringPath) {
        return this.canAccess(this.userService.getUser(), stringPath, repository);
    }

    public boolean canAccess(String repository, String path) {
        return this.canAccess(this.userService.getUser(), path, this.craneConfig.getRepository(repository));
    }

    public boolean canAccess(Authentication auth, String fullPath, Repository repository) {
        if (auth == null || repository == null) {
            return false;
        }
        if (!repository.hasPosixAccessControl()) {
            return true;
        }
        if (!this.pathSupportsPosix(repository.getStoragePath())) {
            this.logger.warn("File system is not posix compliant");
            return true;
        }
        Iterator subsequentPaths = this.getSubsequentPaths(fullPath);
        Path currentPath = repository.getStoragePath();
        while (subsequentPaths.hasNext()) {
            if (!this.canAccessPosix(auth, currentPath)) {
                this.logger.debug("User {} cannot access path {} because they cannot access {}", new Object[]{auth.getName(), fullPath, currentPath});
                return false;
            }
            currentPath = currentPath.resolve((Path)subsequentPaths.next());
        }
        return this.canAccessPosix(auth, currentPath);
    }

    protected Iterator<Path> getSubsequentPaths(String path) {
        return Path.of(path, new String[0]).iterator();
    }

    protected boolean pathSupportsPosix(Path storagePath) {
        return storagePath.getFileSystem().supportedFileAttributeViews().contains("posix");
    }

    protected boolean canAccessPosix(Authentication auth, Path path) {
        PosixFileAttributes attributes;
        int pathGID;
        int pathUID;
        if (auth instanceof AnonymousAuthenticationToken) {
            return false;
        }
        CraneUser craneUser = (CraneUser)auth.getPrincipal();
        try {
            Map<String, Object> pathAttributes = Files.readAttributes(path, "unix:uid,gid", new LinkOption[0]);
            pathUID = (Integer)pathAttributes.get("uid");
            pathGID = (Integer)pathAttributes.get("gid");
            attributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        }
        catch (NoSuchFileException e) {
            return false;
        }
        catch (IOException e) {
            this.logger.warn("Could not view POSIX file system permissions of {}", (Object)path, (Object)e);
            return false;
        }
        Set<PosixFilePermission> permissions = attributes.permissions();
        int userUID = craneUser.getPosixUID();
        if (attributes.owner().getName().equalsIgnoreCase(auth.getName()) || pathUID == userUID) {
            return permissions.contains((Object)this.getOwnerAccess());
        }
        if (this.userService.isMember(auth, attributes.group().getName()) || craneUser.getPosixGIDs().contains(pathGID)) {
            return permissions.contains((Object)this.getGroupAccess());
        }
        return false;
    }
}

