/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.model.config.AccessControl;
import eu.openanalytics.crane.model.config.PathComponent;
import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.service.UserService;
import eu.openanalytics.crane.service.spel.SpecExpressionContext;
import eu.openanalytics.crane.service.spel.SpecExpressionResolver;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public abstract class AbstractPathAccessControlService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SpecExpressionResolver specExpressionResolver;
    protected final UserService userService;
    protected final CraneConfig craneConfig;

    public AbstractPathAccessControlService(SpecExpressionResolver specExpressionResolver, UserService userService, CraneConfig craneConfig) {
        this.specExpressionResolver = specExpressionResolver;
        this.userService = userService;
        this.craneConfig = craneConfig;
    }

    protected abstract AccessControl getAccessControl(PathComponent var1);

    public boolean canAccess(String repository, String path) {
        Repository repositoryObject = this.craneConfig.getRepository(repository);
        if (repositoryObject == null) {
            return false;
        }
        return this.canAccess(repositoryObject, path);
    }

    public boolean canAccess(Repository repository, String fullPath) {
        return this.canAccess(this.userService.getUser(), fullPath, (PathComponent)repository, Path.of(fullPath, new String[0]).iterator());
    }

    public boolean canAccess(Authentication auth, String fullPath, PathComponent pathComponent, Iterator<Path> path) {
        String accessPath = pathComponent.getName() + fullPath;
        if (!this.canAccess(auth, this.getAccessControl(pathComponent))) {
            this.logger.debug("User {} cannot access path {} because they cannot access {}", new Object[]{auth.getName(), accessPath, pathComponent.getName()});
            return false;
        }
        if (!pathComponent.hasPaths()) {
            this.logger.debug("User {} can access path {}, because they can access {}", new Object[]{auth.getName(), accessPath, pathComponent.getName()});
            return true;
        }
        if (!path.hasNext()) {
            this.logger.debug("User {} can access path {}, because they can access {}", new Object[]{auth.getName(), accessPath, pathComponent.getName()});
            return true;
        }
        String nextPartOfRequestedPath = path.next().toString();
        Optional nextPathComponent = pathComponent.getPath(nextPartOfRequestedPath);
        if (nextPathComponent.isEmpty()) {
            this.logger.debug("User {} can access path {}, because there is no access-control for {}", new Object[]{auth.getName(), accessPath, nextPartOfRequestedPath});
            return true;
        }
        return this.canAccess(auth, fullPath, (PathComponent)nextPathComponent.get(), path);
    }

    public boolean canAccess(Authentication auth, AccessControl accessControl) {
        if (auth == null || accessControl == null) {
            return false;
        }
        if (accessControl.getPublic()) {
            return true;
        }
        if (this.allowedByNetwork(auth, accessControl)) {
            return true;
        }
        if (auth instanceof AnonymousAuthenticationToken) {
            return false;
        }
        if (accessControl.isAnyAuthenticatedUser()) {
            return true;
        }
        if (this.allowedByGroups(auth, accessControl)) {
            return true;
        }
        if (this.allowedByUsers(auth, accessControl)) {
            return true;
        }
        return this.allowedByExpression(auth, accessControl);
    }

    public boolean allowedByGroups(Authentication auth, AccessControl accessControl) {
        if (!accessControl.hasGroupAccess()) {
            return false;
        }
        for (String group : accessControl.getGroups()) {
            if (!this.userService.isMember(auth, group)) continue;
            return true;
        }
        return false;
    }

    public boolean allowedByUsers(Authentication auth, AccessControl accessControl) {
        if (!accessControl.hasUserAccess()) {
            return false;
        }
        for (String user : accessControl.getUsers()) {
            if (!auth.getName().equals(user)) continue;
            return true;
        }
        return false;
    }

    public boolean allowedByNetwork(Authentication auth, AccessControl accessControl) {
        if (!accessControl.hasNetworkAccess()) {
            return false;
        }
        WebAuthenticationDetails details = (WebAuthenticationDetails)auth.getDetails();
        if (details == null) {
            return false;
        }
        for (IpAddressMatcher matcher : accessControl.getNetworkMatchers()) {
            if (!matcher.matches(details.getRemoteAddress())) continue;
            return true;
        }
        return false;
    }

    public boolean allowedByExpression(Authentication auth, AccessControl accessControl) {
        if (!accessControl.hasExpressionAccess()) {
            return false;
        }
        SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{auth, auth.getPrincipal(), auth.getCredentials(), accessControl});
        return this.specExpressionResolver.evaluateToBoolean(accessControl.getExpression(), context);
    }
}

