/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service;

import eu.openanalytics.crane.security.auditing.AbstractAuditingService;
import eu.openanalytics.crane.service.AbstractPathAccessControlService;
import eu.openanalytics.crane.service.AbstractPosixAccessControlService;
import eu.openanalytics.crane.service.UserService;

public abstract class AbstractAccessControlService {
    protected AbstractPathAccessControlService pathAccessControlService;
    protected AbstractPosixAccessControlService posixAccessControlService;
    protected AbstractAuditingService auditingService;
    protected UserService userService;

    public boolean canAccess(String repository, String path) {
        boolean canAccess;
        boolean bl = canAccess = this.pathAccessControlService.canAccess(repository, path) && this.posixAccessControlService.canAccess(repository, path);
        if (!canAccess) {
            this.auditingService.createAuthorizationDeniedEvent(this.userService.getUser());
        }
        return canAccess;
    }
}

