/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security.auditing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.security.auditing.FileAuditEventRepository;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.scheduling.annotation.Async;

public class FileAuditEventRepository
implements AuditEventRepository,
AutoCloseable {
    private final Path auditLogFileName;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    private final FileWriter writer;

    public FileAuditEventRepository(CraneConfig craneConfig) throws IOException {
        this.auditLogFileName = craneConfig.getAuditLoggingPath();
        this.writer = new FileWriter(this.auditLogFileName.toFile(), true);
    }

    @Async
    public synchronized void add(AuditEvent event) {
        try {
            this.writer.write(this.objectMapper.writeValueAsString((Object)event) + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }

    public List<AuditEvent> find(String principal, Instant after, String type) {
        if (!this.auditLogFileName.toFile().exists()) {
            return new ArrayList<AuditEvent>();
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.auditLogFileName.toFile()));
            return reader.lines().map(eventString -> {
                try {
                    return ((AuditEventData)this.objectMapper.readValue(eventString, AuditEventData.class)).auditEvent();
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).filter(auditEvent -> {
                boolean condition = true;
                if (principal != null) {
                    condition = auditEvent.getPrincipal().equals(principal);
                }
                if (after != null) {
                    boolean bl = condition = condition && auditEvent.getTimestamp().isAfter(after);
                }
                if (type != null) {
                    condition = condition && auditEvent.getType().equals(type);
                }
                return condition;
            }).toList();
        }
        catch (FileNotFoundException e) {
            return new ArrayList<AuditEvent>();
        }
    }
}

