/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security.auditing;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.security.auditing.FileAuditEventRepository;
import eu.openanalytics.crane.security.auditing.NoAuditEventRepository;
import java.io.IOException;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuditingConfiguration {
    @Bean
    @ConditionalOnProperty(value={"app.audit-logging"})
    public AuditEventRepository auditEventRepository(CraneConfig craneConfig) throws IOException {
        return new FileAuditEventRepository(craneConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuditEventRepository noAuditEventRepository() {
        return new NoAuditEventRepository();
    }
}

