/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security.auditing;

import eu.openanalytics.crane.service.UserService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractAuditingService {
    private final UserService userService;
    protected final AuditEventRepository auditEventRepository;

    public AbstractAuditingService(UserService userService, AuditEventRepository auditEventRepository) {
        this.userService = userService;
        this.auditEventRepository = auditEventRepository;
    }

    public void createErrorHandlerAuditEvent(HttpServletRequest request, HttpStatus status) {
        this.createAuditEvent("ERROR_HANDLER", this.createData(request, status));
    }

    public void createLogoutHandlerAuditEvent(HttpServletRequest request) {
        this.createAuditEvent("LOGOUT", this.createData(request, HttpStatus.OK));
    }

    public void createRepositoryHandlerAuditEvent(HttpServletRequest request) {
        this.createAuditEvent("REPOSITORY_HANDLER", this.createData(request, HttpStatus.OK));
    }

    public void createListRepositoriesAuditEvent(HttpServletRequest request) {
        this.createAuditEvent("LIST_REPOSITORIES", this.createData(request, HttpStatus.OK));
    }

    public void createAuthorizationDeniedEvent(Authentication auth) {
        this.auditEventRepository.add(new AuditEvent(auth.getName(), "AUTHORIZATION_FAILURE", this.createData()));
    }

    public void createAuditEvent(String type, Map<String, Object> data) {
        this.auditEventRepository.add(new AuditEvent(this.getPrincipal(), type, data));
    }

    public Map<String, Object> createData() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return Map.of("request_method", "", "request_path", "", "response_status", 0, "remote_address", "");
        }
        HttpServletRequest request = attributes.getRequest();
        return Map.of("request_method", request.getMethod(), "request_path", this.preparePath(request.getRequestURI()), "response_status", 0, "remote_address", request.getRemoteAddr());
    }

    private String preparePath(String requestURI) {
        if (requestURI.contains("__file")) {
            return requestURI.replaceFirst("/__file", "");
        }
        return requestURI;
    }

    public Map<String, Object> createData(HttpServletRequest request, HttpStatus status) {
        return Map.of("request_method", request.getMethod(), "request_path", this.preparePath(request.getRequestURI()), "response_status", status.value(), "remote_address", request.getRemoteAddr());
    }

    protected String getPrincipal() {
        Authentication authentication = this.userService.getUser();
        return authentication == null ? "anonymousUser" : authentication.getName();
    }
}

