/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;

@Configuration
@ConditionalOnProperty(value={"app.only-public"}, havingValue="true")
@EnableWebSecurity
public class WebSecurityNoAuth {
    @Bean
    protected SecurityFilterChain filterChainNoAuth(HttpSecurity http) throws Exception {
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        requestCache.setMatchingRequestParameterName(null);
        http.httpBasic(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).csrf(Customizer.withDefaults()).authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new String[]{"/", "/.well-known/configured-openid-configuration", "/favicon.ico", "/__file/**", "/__index", "/__assets/css/**", "/__assets/webjars/**", "/actuator/health", "/actuator/health/liveness", "/actuator/health/readiness", "/actuator/auditevents", "/error", "/logout-success"})).permitAll().requestMatchers(new String[]{"/{repoName}/**"})).permitAll());
        return (SecurityFilterChain)http.build();
    }
}

