/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.security.BlockInternalUrlFilter;
import eu.openanalytics.crane.security.CraneJwtAuthenticationConverter;
import eu.openanalytics.crane.security.CraneOidcUserService;
import eu.openanalytics.crane.security.CustomExceptionTranslationFilter;
import eu.openanalytics.crane.security.OpenIdReAuthorizeFilter;
import eu.openanalytics.crane.security.PathTraversalFilter;
import eu.openanalytics.crane.security.TokenParser;
import eu.openanalytics.crane.security.auditing.AuditingService;
import eu.openanalytics.crane.service.spel.SpecExpressionContext;
import eu.openanalytics.crane.service.spel.SpecExpressionResolver;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;

@Configuration
@EnableWebSecurity
@ConditionalOnProperty(value={"app.only-public"}, matchIfMissing=true, havingValue="false")
public class WebSecurity {
    private final CraneConfig craneConfig;
    private final OpenIdReAuthorizeFilter openIdReAuthorizeFilter;
    private final SpecExpressionResolver specExpressionResolver;
    private final AuditingService auditingService;
    private final TokenParser tokenParser;

    public WebSecurity(CraneConfig config, OpenIdReAuthorizeFilter openIdReAuthorizeFilter, SpecExpressionResolver specExpressionResolver, AuditingService auditingService) {
        this.craneConfig = config;
        this.openIdReAuthorizeFilter = openIdReAuthorizeFilter;
        this.specExpressionResolver = specExpressionResolver;
        this.auditingService = auditingService;
        this.tokenParser = new TokenParser(config);
    }

    @Bean
    protected SecurityFilterChain filterChain(HttpSecurity http, SavedRequestAwareAuthenticationSuccessHandler successHandler, CraneConfig craneConfig) throws Exception {
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        requestCache.setMatchingRequestParameterName(null);
        List<String> repoMatchers = craneConfig.getRepositories().stream().map(r -> "/" + r.getName() + "/**").toList();
        http.csrf(Customizer.withDefaults()).authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new String[]{"/", "/.well-known/configured-openid-configuration", "/favicon.ico", "/__file/**", "/__index", "/__assets/css/**", "/__assets/webjars/**", "/actuator/health", "/actuator/health/liveness", "/actuator/health/readiness", "/actuator/auditevents", "/error", "/logout-success"})).permitAll().requestMatchers(repoMatchers.toArray(new String[0]))).permitAll().anyRequest()).authenticated()).exceptionHandling(exception -> exception.accessDeniedPage("/error")).requestCache(cache -> cache.requestCache((RequestCache)requestCache)).oauth2ResourceServer(server -> server.jwt(jwt -> jwt.jwkSetUri(craneConfig.getJwksUri()).jwtAuthenticationConverter((Converter)new CraneJwtAuthenticationConverter(this.tokenParser, craneConfig)))).oauth2Login(login -> login.userInfoEndpoint(endpoint -> endpoint.userAuthoritiesMapper((GrantedAuthoritiesMapper)new NullAuthoritiesMapper()).oidcUserService((OAuth2UserService)new CraneOidcUserService(this.tokenParser, craneConfig))).successHandler((AuthenticationSuccessHandler)successHandler)).oauth2Client(Customizer.withDefaults()).logout(logout -> logout.logoutSuccessHandler(this.getLogoutSuccessHandler())).addFilterBefore((Filter)new PathTraversalFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new BlockInternalUrlFilter(), UsernamePasswordAuthenticationFilter.class).addFilterAfter((Filter)new CustomExceptionTranslationFilter(), ExceptionTranslationFilter.class).addFilterAfter((Filter)this.openIdReAuthorizeFilter, UsernamePasswordAuthenticationFilter.class).requestCache(cache -> cache.requestCache((RequestCache)requestCache));
        return (SecurityFilterChain)http.build();
    }

    public LogoutSuccessHandler getLogoutSuccessHandler() {
        return (httpServletRequest, httpServletResponse, authentication) -> {
            String resolvedLogoutUrl = "/logout-success";
            if (this.craneConfig.getOpenidLogoutUrl() != null) {
                if (authentication != null) {
                    SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{authentication.getPrincipal(), authentication.getCredentials()});
                    resolvedLogoutUrl = this.specExpressionResolver.evaluateToString(this.craneConfig.getOpenidLogoutUrl(), context);
                } else {
                    resolvedLogoutUrl = this.craneConfig.getOpenidLogoutUrl();
                }
            }
            this.auditingService.createLogoutHandlerAuditEvent(httpServletRequest);
            SimpleUrlLogoutSuccessHandler delegate = new SimpleUrlLogoutSuccessHandler();
            delegate.setDefaultTargetUrl(resolvedLogoutUrl);
            delegate.onLogoutSuccess(httpServletRequest, httpServletResponse, authentication);
        };
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler savedRequestAwareAuthenticationSuccessHandler() {
        SavedRequestAwareAuthenticationSuccessHandler savedRequestAwareAuthenticationSuccessHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        savedRequestAwareAuthenticationSuccessHandler.setRedirectStrategy((RedirectStrategy)new /* Unavailable Anonymous Inner Class!! */);
        return savedRequestAwareAuthenticationSuccessHandler;
    }
}

