/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import eu.openanalytics.crane.config.CraneConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class TokenParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CraneConfig config;

    public TokenParser(CraneConfig config) {
        this.config = config;
    }

    public Set<GrantedAuthority> parseAuthorities(Map<String, Object> claims) {
        if (!this.config.hasOpenidGroupsClaim() || !claims.containsKey(this.config.getOpenidGroupsClaim())) {
            return Set.of();
        }
        HashSet<GrantedAuthority> mappedAuthorities = new HashSet<GrantedAuthority>();
        for (String role : this.parseGroupsClaim(claims.get(this.config.getOpenidGroupsClaim()))) {
            Object mappedRole = role.toUpperCase().startsWith("ROLE_") ? role : "ROLE_" + role;
            mappedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(((String)mappedRole).toUpperCase()));
        }
        return mappedAuthorities;
    }

    public int parseUID(Map<String, Object> claims) {
        if (this.config.getOpenidPosixUIDClaim() == null) {
            return -1;
        }
        Object UID = claims.get(this.config.getOpenidPosixUIDClaim());
        if (UID instanceof String) {
            String stringUID = (String)UID;
            try {
                return Integer.parseInt(stringUID);
            }
            catch (NumberFormatException ignored) {
                this.logger.warn("User identifier could not be parsed as an integer {}", (Object)stringUID);
                return -1;
            }
        }
        if (UID instanceof Integer) {
            Integer intUID = (Integer)UID;
            return intUID;
        }
        return -1;
    }

    public List<Integer> parseGIDS(Map<String, Object> claims) {
        if (this.config.getOpenidPosixGIDSClaim() == null) {
            return List.of();
        }
        Object GIDs = claims.get(this.config.getOpenidPosixGIDSClaim());
        if (GIDs instanceof String) {
            String gid = (String)GIDs;
            try {
                return List.of(Integer.valueOf(Integer.parseInt(gid)));
            }
            catch (NumberFormatException ignored) {
                this.logger.warn("Group identifier could not be parsed as an integer {}", (Object)gid);
                return List.of();
            }
        }
        if (GIDs instanceof Integer) {
            Integer gid = (Integer)GIDs;
            return List.of(gid);
        }
        if (GIDs instanceof List) {
            List listGIDS = (List)GIDs;
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (Object gid : listGIDS) {
                if (gid instanceof String) {
                    String gidString = (String)gid;
                    try {
                        result.add(Integer.parseInt(gidString));
                    }
                    catch (NumberFormatException ignored) {
                        this.logger.warn("Group identifier (of list) could not be parsed as an integer {}", gid);
                    }
                    continue;
                }
                if (gid instanceof Integer) {
                    Integer gidInteger = (Integer)gid;
                    result.add(gidInteger);
                    continue;
                }
                this.logger.warn("Group identifier (of list) could is not an integer or string {}", gid);
            }
            return result;
        }
        return List.of();
    }

    private List<String> parseGroupsClaim(Object claimValue) {
        String groupsClaimName = this.config.getOpenidGroupsClaim();
        if (claimValue == null) {
            this.logger.debug("No groups claim with name {} found", (Object)groupsClaimName);
            return new ArrayList<String>();
        }
        this.logger.debug("Matching claim found: {} -> {} ({})", new Object[]{groupsClaimName, claimValue, claimValue.getClass()});
        if (claimValue instanceof Collection) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object object : (Collection)claimValue) {
                if (object == null) continue;
                result.add(object.toString());
            }
            this.logger.debug("Parsed groups claim as Java Collection: {} -> {} ({})", new Object[]{groupsClaimName, result, result.getClass()});
            return result;
        }
        if (claimValue instanceof String) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                Object value = new JSONParser(-1).parse((String)claimValue);
                if (value instanceof List) {
                    List valueList = (List)value;
                    valueList.forEach(o -> result.add(o.toString()));
                }
            }
            catch (ParseException e) {
                this.logger.debug("Unable to parse claim as JSON: {} ->{} {})", new Object[]{groupsClaimName, claimValue, claimValue.getClass()});
            }
            this.logger.debug("Parsed groups claim as JSON: {} -> {} ({})", new Object[]{groupsClaimName, result, result.getClass()});
            return result;
        }
        this.logger.debug("No parser found for groups claim (unsupported type): {} -> {} ({})", new Object[]{groupsClaimName, claimValue, claimValue.getClass()});
        return new ArrayList<String>();
    }
}

