/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;

public class PathTraversalFilter
extends OncePerRequestFilter {
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        if (!this.check(request)) {
            request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.BAD_REQUEST.value());
            request.getRequestDispatcher("/error").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean check(@Nonnull HttpServletRequest request) {
        String path = this.urlPathHelper.getRequestUri(request);
        if (path.contains("%")) {
            return false;
        }
        File absolutePath = new File(path);
        try {
            String canonicalPath = absolutePath.getCanonicalPath();
            if (!new File(canonicalPath).isAbsolute()) {
                return false;
            }
            if (!absolutePath.getAbsolutePath().equals(canonicalPath)) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

