/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenIdReAuthorizeFilter
extends OncePerRequestFilter {
    private final OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager;
    private final OAuth2AuthorizedClientService oAuth2AuthorizedClientService;
    private final Clock clock = Clock.systemUTC();
    private final Duration clockSkew = Duration.ofSeconds(40L);

    public OpenIdReAuthorizeFilter(OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager, OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        this.oAuth2AuthorizedClientService = oAuth2AuthorizedClientService;
        this.oAuth2AuthorizedClientManager = oAuth2AuthorizedClientManager;
    }

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!(auth instanceof OAuth2AuthenticationToken)) {
            this.logger.debug((Object)String.format("No session auth: %s", request.getServletPath()));
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String secFetchMode = request.getHeader("Sec-Fetch-Mode");
        if (secFetchMode != null && !secFetchMode.equals("navigate")) {
            this.logger.debug((Object)String.format("Not trying re-authorization: %s", request.getServletPath()));
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.logger.debug((Object)String.format("Trying re-authorization: %s", request.getServletPath()));
        String clientId = ((OAuth2AuthenticationToken)auth).getAuthorizedClientRegistrationId();
        OAuth2AuthorizedClient authorizedClient = this.oAuth2AuthorizedClientService.loadAuthorizedClient(clientId, auth.getName());
        if (authorizedClient == null) {
            this.invalidateSession(request, response, auth);
        } else if (this.accessTokenExpired(authorizedClient)) {
            OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withAuthorizedClient((OAuth2AuthorizedClient)authorizedClient).principal(auth).build();
            try {
                this.oAuth2AuthorizedClientManager.authorize(authorizeRequest);
                this.logger.info((Object)String.format("OpenID access token refreshed [user: %s, request: %s]", auth.getName(), request.getServletPath()));
            }
            catch (ClientAuthorizationException ex) {
                this.invalidateSession(request, response, auth);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean accessTokenExpired(OAuth2AuthorizedClient authorizedClient) {
        if (authorizedClient == null || authorizedClient.getAccessToken() == null || authorizedClient.getAccessToken().getExpiresAt() == null) {
            return true;
        }
        return this.clock.instant().isAfter(authorizedClient.getAccessToken().getExpiresAt().minus(this.clockSkew));
    }

    private void invalidateSession(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, Authentication auth) {
        this.logger.info((Object)String.format("OpenID access token expired, invalidating internal session [user: %s, request: %s]", auth.getName(), request.getServletPath()));
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }
}

