/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import eu.openanalytics.crane.security.OpenIdReAuthorizeFilter;
import eu.openanalytics.crane.security.RedisOAuth2AuthorizedClientService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.filter.OrderedRequestContextFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;

@Configuration
@ConditionalOnProperty(value={"app.only-public"}, matchIfMissing=true, havingValue="false")
public class OpenIDConfiguration {
    @Bean
    public OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository clientRepository) {
        return new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository, clientRepository);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.session.store-type"}, havingValue="redis")
    public OAuth2AuthorizedClientService redisOAuth2AuthorizedClientService(RedisTemplate<String, OAuth2AuthorizedClient> oAuth2AuthorizedClientRedisTemplate) {
        return new RedisOAuth2AuthorizedClientService(oAuth2AuthorizedClientRedisTemplate);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.session.store-type"}, havingValue="none")
    public OAuth2AuthorizedClientService inMemoryOAuth2AuthorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.session.store-type"}, havingValue="redis")
    public RedisTemplate<String, OAuth2AuthorizedClient> oAuth2AuthorizedClientRedisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        return template;
    }

    @Bean
    public OpenIdReAuthorizeFilter openIdReAuthorizeFilter(OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager, OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        return new OpenIdReAuthorizeFilter(oAuth2AuthorizedClientManager, oAuth2AuthorizedClientService);
    }

    @Bean
    public OrderedRequestContextFilter orderedRequestContextFilter() {
        return new OrderedRequestContextFilter();
    }
}

