/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.model.dto;

import com.fasterxml.jackson.annotation.JsonView;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;

public class ApiResponse<T> {
    private final String status;
    private final Object data;

    public ApiResponse(String status, Object data) {
        this.status = status;
        this.data = data;
    }

    public static <T> ResponseEntity<ApiResponse<T>> success(T data) {
        return ResponseEntity.ok((Object)new ApiResponse("success", data));
    }

    public static <T> ResponseEntity<ApiResponse<T>> created(T data) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)new ApiResponse("success", data));
    }

    public static ResponseEntity<MappingJacksonValue> success(MappingJacksonValue data) {
        data.setValue((Object)new ApiResponse("success", data.getValue()));
        return ResponseEntity.ok((Object)data);
    }

    public static <T> ResponseEntity<ApiResponse<T>> success() {
        return ResponseEntity.ok((Object)new ApiResponse("success", null));
    }

    public static <T> ResponseEntity<ApiResponse<T>> failForbidden() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)new ApiResponse("fail", (Object)"forbidden"));
    }

    public static <T> ResponseEntity<ApiResponse<T>> failUnauthorized() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)new ApiResponse("error", (Object)"unauthorized"));
    }

    public static <T> ResponseEntity<ApiResponse<T>> failNotFound() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)new ApiResponse("error", (Object)"not found"));
    }

    public static <T> ResponseEntity<ApiResponse<T>> fail(Object data) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ApiResponse("fail", data));
    }

    public static <T> ResponseEntity<ApiResponse<T>> error(Object data) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ApiResponse("error", data));
    }

    public static <T> ApiResponse<T> errorBody(Object data) {
        return new ApiResponse("error", data);
    }

    @JsonView
    public String getStatus() {
        return this.status;
    }

    @JsonView
    public Object getData() {
        return this.data;
    }
}

