/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.model.config;

import eu.openanalytics.crane.model.config.AccessControl;
import eu.openanalytics.crane.model.config.CacheRule;
import eu.openanalytics.crane.model.config.PathComponent;
import eu.openanalytics.crane.model.config.RewriteRule;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class Repository
extends PathComponent {
    private String indexFileName = "index.html";
    private List<CacheRule> cache;
    private String storageLocation;
    private Path storagePath;
    private String onErrorExpression;
    private boolean posixAccessControl;
    private List<RewriteRule> rewrites;

    public String getIndexFileName() {
        return this.indexFileName;
    }

    public void setIndexFileName(String indexFileName) {
        this.indexFileName = indexFileName;
    }

    public List<CacheRule> getCache() {
        return this.cache;
    }

    public void setCache(List<CacheRule> cache) {
        this.cache = cache;
    }

    public void validateRepositoryName() {
        List<String> invalidRepositoryNames = List.of("logout", "login", "logout-success", "error", "actuator", "favicon.ico", ".well-known");
        if (invalidRepositoryNames.contains(this.getName()) || this.getName().startsWith("__")) {
            throw new IllegalArgumentException(String.format("Repository name %s is invalid, repository names should not start with '__' and should be different from: %s", this.getName(), invalidRepositoryNames.stream().map(name -> "'" + name + "'").collect(Collectors.joining(", "))));
        }
    }

    public void validate(boolean onlyPublic) {
        super.validate(onlyPublic);
        this.validateRepositoryName();
        AccessControl readAccess = this.getReadAccess();
        if (readAccess.isPublic && (readAccess.hasGroupAccess() || readAccess.hasUserAccess() || readAccess.hasExpressionAccess() || readAccess.hasNetworkAccess() || this.hasPosixAccessControl())) {
            throw new IllegalArgumentException(String.format("Repository %s is invalid, cannot add read access control properties to a public repo", this.getName()));
        }
        AccessControl writeAccess = this.getWriteAccess();
        if (writeAccess.getPublic() && (writeAccess.hasGroupAccess() || writeAccess.hasUserAccess() || writeAccess.hasExpressionAccess() || writeAccess.hasNetworkAccess() || this.hasPosixAccessControl())) {
            throw new IllegalArgumentException(String.format("Repository %s is invalid, cannot add write access control properties to a public repo", this.getName()));
        }
    }

    public boolean hasPosixAccessControl() {
        return this.posixAccessControl;
    }

    public void setPosixAccessControl(Boolean posixAccessControl) {
        this.posixAccessControl = posixAccessControl;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public Path getStoragePath() {
        return this.storagePath;
    }

    public void setStoragePath(Path storagePath) {
        this.storagePath = storagePath;
    }

    public String getOnErrorExpression() {
        return this.onErrorExpression;
    }

    public void setOnErrorExpression(String onErrorExpression) {
        this.onErrorExpression = onErrorExpression;
    }

    public List<RewriteRule> getRewrites() {
        return this.rewrites;
    }

    public void setRewrites(List<RewriteRule> redirects) {
        this.rewrites = redirects;
    }
}

