/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.model.config;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class AccessControl {
    protected List<String> groups;
    protected List<String> users;
    protected boolean isPublic = false;
    protected List<String> network;
    protected Boolean anyAuthenticatedUser;
    protected List<IpAddressMatcher> networkMatchers;
    protected String expression;

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public boolean hasGroupAccess() {
        return this.groups != null && this.groups.size() > 0;
    }

    public boolean hasUserAccess() {
        return this.users != null && this.users.size() > 0;
    }

    public boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public List<String> getNetwork() {
        return this.network;
    }

    public void setNetwork(List<String> accessIpRanges) {
        this.network = accessIpRanges;
        this.networkMatchers = accessIpRanges.stream().map(IpAddressMatcher::new).collect(Collectors.toList());
    }

    public List<IpAddressMatcher> getNetworkMatchers() {
        return this.networkMatchers;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean hasNetworkAccess() {
        return this.network != null && !this.network.isEmpty();
    }

    public boolean hasExpressionAccess() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public boolean isAnyAuthenticatedUser() {
        return this.anyAuthenticatedUser;
    }

    public void setAnyAuthenticatedUser(boolean anyAuthenticatedUser) {
        this.anyAuthenticatedUser = anyAuthenticatedUser;
    }

    public void validate() {
        if (this.anyAuthenticatedUser != null && this.anyAuthenticatedUser.booleanValue() && (this.hasGroupAccess() || this.hasUserAccess() || this.hasExpressionAccess())) {
            throw new IllegalArgumentException("Cannot add user-based access control properties when any-authenticated-user is enabled");
        }
        if (this.isPublic && (this.hasGroupAccess() || this.hasUserAccess() || this.hasExpressionAccess() || this.hasNetworkAccess() || this.anyAuthenticatedUser != null)) {
            throw new IllegalArgumentException("Cannot add access control properties to a public repo");
        }
        if (this.anyAuthenticatedUser == null) {
            this.anyAuthenticatedUser = false;
        }
    }
}

