/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.config;

import eu.openanalytics.crane.model.config.CacheRule;
import eu.openanalytics.crane.model.config.Repository;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.carlspring.cloud.storage.s3fs.S3FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.util.UriComponentsBuilder;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.StsException;

@Component
@ConfigurationProperties(prefix="app")
public class CraneConfig {
    @Autowired
    private Environment environment;
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String storageLocation;
    private String auditLogging;
    private Path auditLoggingPath;
    private String openidIssuerUri;
    private String openidLogoutUrl;
    private String openidGroupsClaim;
    private String openidUsernameClaim = "preferred_username";
    private String templatePath;
    private String logoUrl = "https://www.openanalytics.eu/shinyproxy/logo.png";
    private URI s3Endpoint;
    private Map<String, Repository> repositories = new HashMap();
    private Path root;
    private boolean onlyPublic;
    private List<CacheRule> defaultCache;
    private StsClient stsClient;
    private String callerIdentityArn;
    private String openidPosixUIDClaim;
    private String openidPosixGIDSClaim;

    public Path getRoot() {
        return this.root;
    }

    @PostConstruct
    public void init() throws URISyntaxException {
        this.logoUrl = this.resolveImageURI(this.logoUrl);
        if (this.storageLocation == null) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.storage-location not set");
        }
        if (this.openidIssuerUri == null && !this.onlyPublic) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.openid-issuer-uri not set");
        }
        if (this.environment.containsProperty("app.repositories[0].name")) {
            throw new IllegalArgumentException("Listing syntax was used instead of a map for listing repositories. Have a look at Crane's documentation.");
        }
        if (this.repositories.isEmpty()) {
            throw new IllegalArgumentException("Incorrect configuration detected: no repositories configured");
        }
        if (this.auditLogging != null) {
            FileSystem fs = FileSystems.getFileSystem(new URI("file:///"));
            this.auditLoggingPath = fs.getPath(new URI(this.auditLogging).getPath(), new String[0]);
        }
        this.root = this.storageLocationToPath(this.storageLocation);
        this.repositories.values().forEach(r -> r.validate(this.onlyPublic));
        for (Repository r2 : this.repositories.values()) {
            if (this.defaultCache != null && r2.getCache() == null) {
                r2.setCache(this.defaultCache);
            }
            if (r2.getStorageLocation() == null) {
                Path repositoryStoragePath = this.root.resolve(r2.getName() + "/");
                r2.setStoragePath(repositoryStoragePath);
                r2.setStorageLocation(repositoryStoragePath.toString());
                continue;
            }
            r2.setStoragePath(this.storageLocationToPath(this.validateRepositoryStorageLocation(r2.getStorageLocation(), r2.getName())));
        }
        this.close();
    }

    private void close() {
        if (this.stsClient != null) {
            this.stsClient.close();
        }
    }

    private Path storageLocationToPath(String storageLocation) throws URISyntaxException {
        if (storageLocation.startsWith("s3://")) {
            Path path;
            block12: {
                this.checkStsAuthentication();
                if (this.s3Endpoint == null) {
                    this.s3Endpoint = new URI("https:///");
                }
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("s3fs.protocol", this.s3Endpoint.getScheme());
                URI uri = new URI(storageLocation);
                String path2 = new URI("/" + uri.getAuthority() + uri.getPath()).getPath();
                FileSystem fs = FileSystems.newFileSystem(URI.create("s3:" + this.s3Endpoint.getSchemeSpecificPart()), env, Thread.currentThread().getContextClassLoader());
                try {
                    Path storageLocationPath = fs.getPath(path2, new String[0]);
                    Files.list(storageLocationPath).close();
                    path = storageLocationPath;
                    if (fs == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | S3Exception e) {
                        throw new IllegalArgumentException("Crane cannot access the following storage location '%s'".formatted(storageLocation), e);
                    }
                }
                fs.close();
            }
            return path;
        }
        FileSystem fs = FileSystems.getFileSystem(new URI("file:///"));
        try {
            Files.list(Path.of(storageLocation, new String[0])).close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Crane cannot access the following storage location '%s'".formatted(storageLocation), e);
        }
        return fs.getPath(new URI(storageLocation).getPath(), new String[0]);
    }

    private void checkStsAuthentication() {
        if (this.stsClient == null) {
            this.stsClient = StsClient.create();
        }
        try {
            if (this.callerIdentityArn == null) {
                this.callerIdentityArn = this.stsClient.getCallerIdentity().arn();
            }
            this.logger.info("Using AWS identity: {}", (Object)this.callerIdentityArn);
        }
        catch (StsException exception) {
            this.logger.info("Not authenticated with AWS, enable debug logs in case this unexpected.");
            this.logger.debug("Not authenticated with AWS", (Throwable)exception);
        }
    }

    protected String resolveImageURI(String resourceURI) {
        if (resourceURI == null || resourceURI.isEmpty()) {
            return null;
        }
        String resolvedValue = resourceURI;
        if (resourceURI.toLowerCase().startsWith("file://")) {
            String mimetype = URLConnection.guessContentTypeFromName(resourceURI);
            if (mimetype == null) {
                this.logger.warn("Cannot determine mimetype for resource: {}", (Object)resourceURI);
            } else {
                try (InputStream input = new URL(resourceURI).openConnection().getInputStream();){
                    byte[] data = StreamUtils.copyToByteArray((InputStream)input);
                    String encoded = Base64.getEncoder().encodeToString(data);
                    resolvedValue = String.format("data:%s;base64,%s", mimetype, encoded);
                }
                catch (IOException e) {
                    this.logger.warn("Failed to convert file URI to data URI: {}", (Object)resourceURI, (Object)e);
                }
            }
        }
        return resolvedValue;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = this.validateStorageLocation(storageLocation, "app.storage-location");
    }

    public String validateRepositoryStorageLocation(String storageLocation, String repositoryName) {
        return this.validateStorageLocation(storageLocation, String.format("app.repositories[%s].storage-location", repositoryName));
    }

    public String validateStorageLocation(String storageLocation, String option) {
        if (storageLocation.startsWith("s3://")) {
            if (!storageLocation.startsWith("s3://") || !storageLocation.endsWith("/")) {
                throw new IllegalArgumentException(String.format("Incorrect configuration detected: %s must either start and end with / OR start with s3:// and end with /", option));
            }
            return storageLocation;
        }
        if (!storageLocation.startsWith("/") || !storageLocation.endsWith("/")) {
            throw new IllegalArgumentException(String.format("Incorrect configuration detected: %s must either start and end with / OR start with s3:// and end with /", option));
        }
        File path = new File(storageLocation);
        if (!path.exists() || !path.isDirectory()) {
            throw new IllegalArgumentException(String.format("Incorrect configuration detected: %s does not exists or is not a directory", option));
        }
        return storageLocation;
    }

    public String getOpenidIssuerUri() {
        return this.openidIssuerUri;
    }

    public void setOpenidIssuerUri(String openidIssuerUri) {
        this.openidIssuerUri = openidIssuerUri;
    }

    public String getJwksUri() {
        ClientRegistration clientRegistration = ClientRegistrations.fromIssuerLocation((String)this.getOpenidIssuerUri()).clientId("bogus").build();
        return clientRegistration.getProviderDetails().getJwkSetUri();
    }

    public String getConfiguredOpenIdMetadataUrl() {
        URI issuer = URI.create(this.openidIssuerUri);
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(issuer.getPath() + OIDC_METADATA_PATH).build(Collections.emptyMap()).toString();
    }

    public Collection<Repository> getRepositories() {
        return this.repositories.values();
    }

    public void setRepositories(Map<String, Repository> repositories) {
        repositories.forEach((repositoryName, repository) -> repository.setName(repositoryName));
        this.repositories = repositories;
    }

    public Repository getRepository(String name) {
        return (Repository)this.repositories.get(name);
    }

    public boolean hasOpenidGroupsClaim() {
        return this.openidGroupsClaim != null && !this.openidGroupsClaim.isEmpty();
    }

    public String getOpenidGroupsClaim() {
        return this.openidGroupsClaim;
    }

    public void setOpenidGroupsClaim(String openidGroupsClaim) {
        this.openidGroupsClaim = openidGroupsClaim;
    }

    public String getOpenidUsernameClaim() {
        return this.openidUsernameClaim;
    }

    public void setOpenidUsernameClaim(String openidUsernameClaim) {
        this.openidUsernameClaim = openidUsernameClaim;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        if (!templatePath.endsWith("/")) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.template-path must end with /");
        }
        this.templatePath = templatePath;
    }

    public URI getS3Endpoint() {
        return this.s3Endpoint;
    }

    public void setS3Endpoint(URI s3Endpoint) {
        if (!Objects.equals(s3Endpoint.getScheme(), "http") && !Objects.equals(s3Endpoint.getScheme(), "https")) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.s3-endpoint must start with http:// or https://");
        }
        this.s3Endpoint = s3Endpoint;
    }

    public String getOpenidLogoutUrl() {
        return this.openidLogoutUrl;
    }

    public void setOpenidLogoutUrl(String openidLogoutUrl) {
        this.openidLogoutUrl = openidLogoutUrl;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public List<CacheRule> getDefaultCache() {
        return this.defaultCache;
    }

    public void setDefaultCache(List<CacheRule> defaultCache) {
        this.defaultCache = defaultCache;
    }

    public String getAuditLogging() {
        return this.auditLogging;
    }

    public void setAuditLogging(String auditLogging) {
        this.auditLogging = auditLogging;
    }

    public Path getAuditLoggingPath() {
        return this.auditLoggingPath;
    }

    public String getOpenidPosixUIDClaim() {
        return this.openidPosixUIDClaim;
    }

    public void setOpenidPosixUIDClaim(String openidPosixUIDClaim) {
        this.openidPosixUIDClaim = openidPosixUIDClaim;
    }

    public String getOpenidPosixGIDSClaim() {
        return this.openidPosixGIDSClaim;
    }

    public void setOpenidPosixGIDSClaim(String openidPosixGIDSClaim) {
        this.openidPosixGIDSClaim = openidPosixGIDSClaim;
    }

    public boolean usesS3() {
        if (this.root.getFileSystem() instanceof S3FileSystem) {
            return true;
        }
        for (Repository repository : this.repositories.values()) {
            if (!(repository.getStoragePath().getFileSystem() instanceof S3FileSystem)) continue;
            return true;
        }
        return false;
    }

    public void setOnlyPublic(boolean onlyPublic) {
        this.onlyPublic = onlyPublic;
    }

    public boolean isOnlyPublic() {
        return this.onlyPublic;
    }
}

