/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane;

import eu.openanalytics.crane.BaseUIController;
import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.model.config.PathComponent;
import eu.openanalytics.crane.model.dto.ApiResponse;
import eu.openanalytics.crane.security.auditing.AuditingService;
import eu.openanalytics.crane.service.PathReadAccessControlService;
import eu.openanalytics.crane.service.PosixReadAccessControlService;
import eu.openanalytics.crane.service.UserService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MainController
extends BaseUIController {
    private final PathReadAccessControlService pathReadAccessControlService;
    private final PosixReadAccessControlService posixReadAccessControlService;
    private final AuditingService auditingService;

    public MainController(CraneConfig config, UserService userService, PathReadAccessControlService pathReadAccessControlService, PosixReadAccessControlService posixReadAccessControlService, AuditingService auditingService) {
        super(userService, config);
        this.pathReadAccessControlService = pathReadAccessControlService;
        this.posixReadAccessControlService = posixReadAccessControlService;
        this.auditingService = auditingService;
    }

    @GetMapping(value={"/.well-known/configured-openid-configuration"})
    public void getOpenIdConfigurationUrl(HttpServletResponse response) {
        response.setHeader("Location", this.config.getConfiguredOpenIdMetadataUrl());
        response.setStatus(302);
    }

    @GetMapping(value={"/"}, produces={"text/html"})
    public String getRepositoriesAsHtml(HttpServletRequest request, ModelMap map) {
        boolean authenticated = this.userService.isAuthenticated();
        List repositories = this.config.getRepositories().stream().filter(r -> this.pathReadAccessControlService.canAccess(r.getName(), "/") && this.posixReadAccessControlService.canAccess(r.getName(), "/")).map(PathComponent::getName).collect(Collectors.toList());
        this.auditingService.createListRepositoriesAuditEvent(request);
        if (repositories.isEmpty() && !authenticated) {
            return "redirect:" + this.userService.getLoginUrl();
        }
        map.put((Object)"repositories", repositories);
        this.prepareMap(map);
        return "repositories";
    }

    @ResponseBody
    @GetMapping(value={"/"}, produces={"application/json"})
    public ResponseEntity<ApiResponse<Map<String, Object>>> getRepositoriesAsJson(HttpServletRequest request) {
        return ApiResponse.success(Map.of("directories", this.config.getRepositories().stream().filter(r -> this.pathReadAccessControlService.canAccess(r.getName(), "/") && this.posixReadAccessControlService.canAccess(r.getName(), "/")).map(PathComponent::getName).toList()));
    }
}

