/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane;

import eu.openanalytics.crane.BaseUIController;
import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.service.UserService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Controller
public class ErrorsController
extends BaseUIController
implements ErrorController {
    public ErrorsController(UserService userService, CraneConfig craneConfig) {
        super(userService, craneConfig);
    }

    @RequestMapping(value={"/error"}, produces={"text/html"}, method={RequestMethod.GET})
    public ModelAndView handleErrorAsHtml(HttpServletRequest request, HttpServletResponse response, ModelMap map, Authentication auth) {
        int status = this.getStatus(request, response);
        this.setNoCacheHeader(response);
        map.put((Object)"mainPage", (Object)ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString());
        map.put((Object)"resource", request.getAttribute("jakarta.servlet.forward.servlet_path"));
        this.prepareMap(map);
        if (status == HttpStatus.NOT_FOUND.value() || status == HttpStatus.FORBIDDEN.value()) {
            return new ModelAndView("not-found", (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ModelAndView("not-found", (HttpStatusCode)HttpStatus.valueOf((int)status));
    }

    @RequestMapping(value={"/error"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> handleError(HttpServletRequest request, HttpServletResponse response) {
        this.setNoCacheHeader(response);
        int status = this.getStatus(request, response);
        String error = "error";
        if (request.getMethod().equals(HttpMethod.POST.name()) && (status == HttpStatus.NOT_FOUND.value() || status == HttpStatus.FORBIDDEN.value())) {
            error = "forbidden";
            status = 403;
        } else if (status == HttpStatus.NOT_FOUND.value() || status == HttpStatus.FORBIDDEN.value()) {
            error = "not-found";
            status = 404;
        }
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("status", error);
        resp.put("code", status);
        resp.put("resource", request.getAttribute("jakarta.servlet.forward.servlet_path").toString());
        return new ResponseEntity(resp, (HttpStatusCode)HttpStatus.valueOf((int)status));
    }

    @RequestMapping(value={"/logout-success"}, method={RequestMethod.GET})
    public String getLogoutSuccessPage(HttpServletResponse response, ModelMap map) {
        this.setNoCacheHeader(response);
        this.prepareMap(map);
        map.put((Object)"mainPage", (Object)ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString());
        map.put((Object)"authenticated", (Object)false);
        return "logout-success";
    }

    private void setNoCacheHeader(HttpServletResponse response) {
        response.setHeader("Cache-Control", CacheControl.noCache().getHeaderValue());
    }

    private int getStatus(HttpServletRequest request, HttpServletResponse response) {
        Object status = request.getAttribute("jakarta.servlet.error.status_code");
        if (status != null) {
            return Integer.parseInt(status.toString());
        }
        if (response.getStatus() != 200) {
            return response.getStatus();
        }
        return 500;
    }
}

