/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane;

import com.google.common.collect.Streams;
import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.model.config.CacheRule;
import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.model.config.RewriteRule;
import eu.openanalytics.crane.security.auditing.AuditingService;
import eu.openanalytics.crane.service.HandleSpecExpressionService;
import eu.openanalytics.crane.service.UserService;
import eu.openanalytics.crane.service.spel.SpecExpressionContext;
import eu.openanalytics.crane.service.spel.SpecExpressionResolver;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.parameters.P;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class DownloadController {
    private final ResourceHttpMessageConverter resourceHttpMessageConverter = new ResourceHttpMessageConverter();
    private final AuditingService auditingService;
    private final HandleSpecExpressionService handleSpecExpressionService;
    private final CraneConfig craneConfig;
    private final SpecExpressionResolver specExpressionResolver;
    private final UserService userService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DownloadController(AuditingService auditingService, HandleSpecExpressionService handleSpecExpressionService, CraneConfig craneConfig, SpecExpressionResolver specExpressionResolver, UserService userService) {
        this.auditingService = auditingService;
        this.handleSpecExpressionService = handleSpecExpressionService;
        this.craneConfig = craneConfig;
        this.specExpressionResolver = specExpressionResolver;
        this.userService = userService;
    }

    @PreAuthorize(value="@readAccessControlService.canAccess(#r, #p)")
    @GetMapping(value={"/__file/{repository}/{*path}"})
    public void read(HttpServletRequest request, HttpServletResponse response, @P(value="r") @PathVariable(name="repository") String stringRepository, @P(value="p") @PathVariable(name="path") String stringPath, RedirectAttributes redirectAttributes) throws ServletException, IOException {
        Repository repository = this.craneConfig.getRepository(stringRepository);
        String relativePath = String.join((CharSequence)"/", Streams.stream(Path.of(stringPath, new String[0]).iterator()).map(Path::toString).toList());
        Path path = repository.getStoragePath().resolve(relativePath);
        if (!stringPath.endsWith("/") && Files.isDirectory(path, new LinkOption[0])) {
            response.sendRedirect(request.getRequestURI().replaceFirst("/__file", "") + "/");
            return;
        }
        Optional redirect = this.checkRewriteRules(repository, Path.of(stringPath, new String[0]), request, response);
        if (redirect.isPresent()) {
            this.logger.debug("Rewriting '{}' to '{}'", (Object)stringPath, redirect.get());
            request.getRequestDispatcher("/__file" + (String)redirect.get()).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve(repository.getIndexFileName());
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Path directory;
            if (path.endsWith(repository.getIndexFileName()) && Files.isDirectory(directory = path.getParent(), new LinkOption[0])) {
                request.setAttribute("path", (Object)directory);
                request.setAttribute("repo", (Object)repository);
                this.auditingService.createRepositoryHandlerAuditEvent(request);
                request.getRequestDispatcher("/__index").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.NOT_FOUND.value());
            this.auditingService.createErrorHandlerAuditEvent(request, HttpStatus.NOT_FOUND);
            if (this.handleSpecExpressionService.handleByOnErrorExpression(repository, request, response, HttpStatus.NOT_FOUND.value())) {
                return;
            }
            request.getRequestDispatcher("/error").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (new ServletWebRequest(request, response).checkNotModified(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis())) {
            return;
        }
        this.auditingService.createRepositoryHandlerAuditEvent(request);
        InputStreamResource resource = new InputStreamResource(Files.newInputStream(path, new OpenOption[0]));
        this.addCachingHeaders(request, response, repository);
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        MediaType mediaType = this.getMediaType(path);
        this.resourceHttpMessageConverter.write((Object)resource, mediaType, (HttpOutputMessage)outputMessage);
    }

    private void addCachingHeaders(HttpServletRequest request, HttpServletResponse response, Repository repository) {
        for (Map.Entry cacheRule : this.computeCacheRules(repository).entrySet()) {
            if (!((AntPathRequestMatcher)cacheRule.getKey()).matches(request)) continue;
            response.setHeader("Cache-Control", (String)cacheRule.getValue());
            break;
        }
    }

    private MediaType getMediaType(Path path) {
        Tika tika = new Tika();
        String mimeType = tika.detect(path.getFileName().toString());
        return MediaType.valueOf((String)mimeType);
    }

    private Map<AntPathRequestMatcher, String> computeCacheRules(Repository repository) {
        HashMap<AntPathRequestMatcher, String> cacheRules = new HashMap<AntPathRequestMatcher, String>();
        if (repository.getCache() != null) {
            for (CacheRule cache : repository.getCache()) {
                cacheRules.put(new AntPathRequestMatcher(cache.getPattern()), CacheControl.maxAge((Duration)cache.getMaxAge()).getHeaderValue());
            }
        }
        return cacheRules;
    }

    private Optional<String> checkRewriteRules(Repository repository, Path path, HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = this.userService.getUser();
        if (repository.getRewrites() == null) {
            return Optional.empty();
        }
        for (RewriteRule redirectRule : repository.getRewrites()) {
            SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{auth, auth.getPrincipal(), auth.getCredentials(), repository, request, response, path});
            if (!this.specExpressionResolver.evaluateToBoolean(redirectRule.getMatcher(), context).booleanValue()) continue;
            return Optional.of(this.specExpressionResolver.evaluateToString(redirectRule.getDestination(), context));
        }
        return Optional.empty();
    }
}

